import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define the grid size
rows, cols = 5, 4

# Define the colors for tiles
white_color = 'white'
black_color = 'black'
clear_color = 'lightgreen'

# Define the robot colors
robot1_color = 'white'
robot2_color = 'black'

# Define the tile status for goal state
tile_status = {
    'tile_0-1': 'clear', 'tile_0-2': 'clear', 'tile_0-3': 'clear', 'tile_0-4': 'clear',
    'tile_1-1': 'painted white', 'tile_1-2': 'painted black', 'tile_1-3': 'painted white', 'tile_1-4': 'painted black',
    'tile_2-1': 'painted black', 'tile_2-2': 'painted white', 'tile_2-3': 'painted black', 'tile_2-4': 'painted white',
    'tile_3-1': 'painted white', 'tile_3-2': 'painted black', 'tile_3-3': 'painted white', 'tile_3-4': 'painted black',
    'tile_4-1': 'painted black', 'tile_4-2': 'painted white', 'tile_4-3': 'painted black', 'tile_4-4': 'painted white',
}

# Draw the tiles
for row in range(rows):
    for col in range(cols):
        tile_id = f'tile_{row}-{col+1}'
        status = tile_status[tile_id]
        if 'white' in status:
            color = white_color
        elif 'black' in status:
            color = black_color
        else:
            color = clear_color
        rect = patches.Rectangle((col, rows-row-1), 1, 1, linewidth=1, edgecolor='black', facecolor=color)
        ax.add_patch(rect)
        ax.text(col + 0.5, rows-row-0.5, tile_id, ha='center', va='center', fontsize=8, color='black')

# Draw the robots at the bottom
robot_positions = {
    'robot1': (0, -0.5),
    'robot2': (0, -1.5),
}

for robot, (row, col) in robot_positions.items():
    color = robot1_color if robot == 'robot1' else robot2_color
    circle = patches.Circle((col + 0.5, -0.5), 0.3, edgecolor='black', facecolor=color)
    ax.add_patch(circle)
    ax.text(col + 0.5, -0.7, f'{robot}\n(no constraints)', ha='center', va='center', fontsize=8, color='black' if color == 'white' else 'white')

# Set limits and labels
ax.set_xlim(-2, cols)
ax.set_ylim(-1, rows)
ax.set_xticks([])
ax.set_yticks([])

# Add legend
legend_elements = [
    patches.Patch(facecolor=clear_color, edgecolor='black', label='Clear Tile'),
    patches.Patch(facecolor=white_color, edgecolor='black', label='Painted White'),
    patches.Patch(facecolor=black_color, edgecolor='black', label='Painted Black'),
    patches.Patch(facecolor=robot1_color, edgecolor='black', label='Robot1 (White)'),
    patches.Patch(facecolor=robot2_color, edgecolor='black', label='Robot2 (Black)'),
]
ax.legend(handles=legend_elements, loc='upper right', bbox_to_anchor=(1.3, 1))

# Save the figure
plt.savefig('tiles/one_shot/goal_diagram_code/attempts/goal_diagram_attempt_1.png', bbox_inches='tight')
plt.show()
# VERIFICATION FAILED:
# Tiles in row 0 should remain unpainted, but tile_0-4 is missing. Additionally, robots should not be shown in the goal state.
